/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.gui.actions.grammar;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.nooj4nlp.controller.GrammarEditorShell.GrammarEditorShellController;
import net.nooj4nlp.engine.Paths;
import net.nooj4nlp.gui.main.Launcher;
import net.nooj4nlp.gui.shells.GrammarEditorShell;
import org.apache.commons.io.FilenameUtils;

public class ExportGrammarActionListener
implements ActionListener {
    private GrammarEditorShell editor;
    private GrammarEditorShellController controller;

    public ExportGrammarActionListener(GrammarEditorShell shell) {
        this.editor = shell;
        this.controller = this.editor.getController();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        JFileChooser saveGraphChooser = new JFileChooser();
        saveGraphChooser.setDialogTitle("Save as");
        saveGraphChooser.setAcceptAllFileFilterUsed(false);
        String currentDirToBeSetPath = FilenameUtils.concat(Paths.docDir, FilenameUtils.concat(this.controller.lan.isoName, "Syntactic Analysis"));
        saveGraphChooser.setCurrentDirectory(new File(currentDirToBeSetPath));
        FileNameExtensionFilter filterGrammar = new FileNameExtensionFilter("Graph (*.grf)", "grf");
        saveGraphChooser.addChoosableFileFilter(filterGrammar);
        saveGraphChooser.setFileFilter(filterGrammar);
        if (saveGraphChooser.showSaveDialog(null) == 1) {
            return;
        }
        File selectedFile = saveGraphChooser.getSelectedFile();
        String fileName = FilenameUtils.removeExtension(selectedFile.getName()) + "." + "grf";
        String parentPath = selectedFile.getParent();
        String filePath = parentPath + System.getProperty("file.separator") + fileName;
        if ((selectedFile = new File(filePath)).exists()) {
            int value = JOptionPane.showOptionDialog(Launcher.getDesktopPane(), fileName + " already exists." + " \n Do you want to replace it?", "Confirm Save As", 0, 2, null, null, null);
            if (value == 1 || value == -1) {
                return;
            }
            selectedFile.delete();
        }
        this.controller.SaveGraph(filePath);
    }
}

